% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program TemporalResponse.m
% ESC to exit program anytime.

function TemporalResponse (nFrames)

%% Display Setup Module
% Define display parameters
whichScreen = max(Screen('screens'));
p.ScreenGamma = 2;	% from monitor calibration
p.ScreenBackground = 0;

% Open display window and hide the mouse cursor

if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca); end % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', 'FloatingPoint32BitIfPossible');   % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', 'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', 'DisplayColorCorrection', 'SimpleGamma');
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', whichScreen, p.ScreenBackground);
PsychColorCorrection('SetEncodingGamma', windowPtr, 1 / p.ScreenGamma);
HideCursor;

vbl=Screen('Flip', windowPtr);

%% Experimental Module

% Specify the stimulus
if nargin < 1, nFrames = 1; end  % number of frames 
                                 % of the square
p.stimSize = [100 100];  % horizontal and vertical size 
                         % in pixels
p.interval = 0.2;        % seconds between two flashes

% Compute stimulus parameters
p.ScreenFrameRate = FrameRate(windowPtr);
rect = CenterRect([0 0 p.stimSize], p.ScreenRect);
flipWait = (nFrames - 0.5) / p.ScreenFrameRate;

% Show the square at the specified location and with 
% specified interval
while 1
    key = WaitTill(vbl + p.interval, 'esc'); 
        % wait till next flash
    if ~isempty(key), break; end 
    
    Screen('FillRect', windowPtr, 1, rect);
    vbl = Screen('Flip', windowPtr); % turn on flash
    vbl = Screen('Flip', windowPtr, vbl + flipWait); 
        % turn off after nFrames   
end 
   
%% System Reinstatement Module
Screen('CloseAll'); % close window and textures

